%% Griewank Function 
% This function is strongly multi-modal with significant interaction
% between its variable, caused by the product term. This function has a
% interesting property that the number of local increase with
% dimensionality. However, the influence of the product term also
% diminishes dramatically in these circumstances. In fact it becomes
% negligible once the n>30. 
% 
% * It is multi-modal function
% * Minimum at : [100, 100, ..., 100]
% * Minimum Value : 0
% * Maxima : 22.35040
% * Maximum Dimensionality : 10 and 30
%% 
% *Function definition* 
%
% $$f(<x_i>) = 1+\frac{\sum_{i=1}^n(x_i-100)^2}{4000}-\prod_{i=1}^n\cos\frac{x_i-100}{\sqrt{i}}$$
%%
% *3D plot*
    clc; clear
    x = -5:0.2:5; y = -5:0.2:5;
    xy=zeros(length(x)*length(y),2);
    cntpts=0;
    for ii=1:length(x)
        for jj=1:length(y)
            cntpts=cntpts+1;
            xy(cntpts,1:2)=[x(ii),y(jj)];
        end
    end
    funval = Schaffer([xy]);
    funval = reshape(funval, length(y),length(x));
    surfc(x, y, funval)
%%
% *Other Useful Functions*
% 
% <DeJong>  <Rosenbrock> <Ackley> <Alpine> <Rastrigin>  <Griewank> <Schaffer>
%